/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.AbortMsg;
import com.ibm.hwmca.fw.rbf.impl.AbortReply;
import com.ibm.hwmca.fw.rbf.impl.CommManager;
import com.ibm.hwmca.fw.rbf.impl.HandlerPreparer;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class AbortThread
extends Thread {
    private static final String TRACE_MASKT = "XRBFABTT";
    private static final String TRACE_MASKF = "XRBFABTF";
    private static final String TRACE_MASKD = "XRBFABTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-AbrtThrd");
    private RbfRequest request;
    private RbfRequestId requestId;
    private Set targets = new HashSet();
    private int status;
    private static final int ABORT_MSG_TIMEOUT = 180000;

    AbortThread(RbfRequest request, MachineId target, int status) {
        super("RBF Abort Thread " + request.getIdentifier());
        this.request = request;
        this.requestId = request.getIdentifier();
        this.targets.add(target);
        this.status = status;
        Trace.trace(TRACE_MASKT, "<> AbortThread() " + this.requestId);
    }

    AbortThread(RbfRequest request, Set targets, int status) {
        super("RBF Abort Thread " + request.getIdentifier());
        this.request = request;
        this.requestId = request.getIdentifier();
        this.targets.addAll(targets);
        this.status = status;
        Trace.trace(TRACE_MASKT, "<> AbortThread() " + this.requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Trace.trace(TRACE_MASKT, "-> Aborts beginning " + this.requestId);
        if (!this.targets.isEmpty()) {
            AbortMsg abortMsg = new AbortMsg(this.requestId, this.status);
            RequestTrackingData trackingData = this.request.getTrackingData();
            Iterator iterator = this.targets.iterator();
            while (iterator.hasNext()) {
                MachineId target = (MachineId)iterator.next();
                AbortReply abortReply = this.sendAbortMsg(abortMsg, target);
                if (abortReply == null) continue;
                int abortReplyStatus = abortReply.getStatus();
                if (!abortReply.isValidStatus(abortReplyStatus)) {
                    String desc = "Internal error: Invalid abort reply status (" + abortReplyStatus + ") received from " + RbfUtils.getMachineInfo(target) + " " + this.requestId;
                    Trace.trace(TRACE_MASKF, desc);
                    FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                    fl.add(desc);
                    fl.add(RbfUtils.getLoggingInfo(this.request));
                    fl.log();
                    RequestTrackingData requestTrackingData = trackingData;
                    synchronized (requestTrackingData) {
                        trackingData.removeAborting(target);
                        trackingData.addUnusable(target);
                        if (trackingData.isHandlerNeeded()) {
                            HandlerPreparer.prepareHandlers(this.request);
                        }
                        continue;
                    }
                }
                if (abortReplyStatus != 0) continue;
                RequestTrackingData requestTrackingData = trackingData;
                synchronized (requestTrackingData) {
                    trackingData.removeAborting(target);
                    if (trackingData.isHandlerNeeded()) {
                        HandlerPreparer.prepareHandlers(this.request);
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- Aborts ending " + this.requestId);
    }

    private AbortReply sendAbortMsg(AbortMsg msg, MachineId target) {
        try {
            CommManager commMgr = CommManager.getCommManager();
            RbfReply reply = commMgr.send(msg, target, 180000);
            if (reply instanceof AbortReply) {
                return (AbortReply)reply;
            }
            String desc = "Internal error: Invalid abort reply (" + reply.getClass().getName() + ") received from " + RbfUtils.getMachineInfo(target) + " " + this.requestId;
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(this.request));
            fl.log();
            return null;
        }
        catch (RbfException rbfe) {
            return null;
        }
    }
}

